/*
 * Decompiled with CFR 0.152.
 */
package org.gdal.ogr;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.ogrJNI;

class GeometryNative
extends WeakReference {
    private long swigCPtr;
    private static ReferenceQueue refQueue = new ReferenceQueue();
    private static Set refList = Collections.synchronizedSet(new HashSet());
    private static Thread cleanupThread = null;

    public GeometryNative(Geometry javaObject, long cPtr) {
        super(javaObject, refQueue);
        if (cleanupThread == null) {
            GeometryNative nativeObject;
            while ((nativeObject = (GeometryNative)refQueue.poll()) != null) {
                nativeObject.delete();
            }
        }
        refList.add(this);
        this.swigCPtr = cPtr;
    }

    public void dontDisposeNativeResources() {
        refList.remove(this);
        this.swigCPtr = 0L;
    }

    public void delete() {
        refList.remove(this);
        if (this.swigCPtr != 0L) {
            ogrJNI.delete_Geometry(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    static {
        cleanupThread = new Thread(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            GeometryNative nativeObject;
                            if ((nativeObject = (GeometryNative)refQueue.remove()) == null) {
                                continue;
                            }
                            nativeObject.delete();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        try {
            cleanupThread.setName("GeometryNativeObjectsCleaner");
            cleanupThread.setDaemon(true);
            cleanupThread.start();
        }
        catch (SecurityException se) {
            cleanupThread = null;
        }
    }
}

