(defproject {{ns-name}} "0.1.0"
  :dependencies [[org.clojure/clojure "1.10.3"]
                 [org.clojure/clojurescript "1.10.879"
                  :exclusions
                  [com.google.javascript/closure-compiler-unshaded
                   org.clojure/google-closure-library
                   org.clojure/google-closure-library-third-party
                   com.cognitect/transit-clj]]

                 [re-frame "1.2.0"]
                 [com.7theta/via "8.3.1"]{{#auth?}}
                 [com.7theta/via-auth "0.5.1"]{{/auth?}}
                 [metosin/reitit-frontend "0.5.15"]

                 [integrant "0.8.0"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[binaryage/devtools "1.0.3"]
                                  [thheller/shadow-cljs "2.15.5"]
                                  [com.7theta/structor "0.1.0"]
                                  [integrant/repl "0.3.2"]]}
             :uberjar {:source-paths ["prod"]
                       :resource-paths ["resources/public/js/compiled"]
                       :dependencies [[yogthos/config "1.1.8"]]
                       :main {{name}}.main
                       :aot :all
                       :uberjar-name "{{name}}.jar"}}
  :prep-tasks ["compile"])
