(ns {{name}}.main
    (:require [{{name}}.config :refer [config]]
              [config.core :refer [env]]
              [integrant.core :as ig])
    (:import [java.util Properties]
           [java.net ServerSocket])
    (:gen-class))

(defn- allocate-free-port!
  []
  (let [socket (ServerSocket. 0)]
    (.setReuseAddress socket true)
    (let [port (.getLocalPort socket)]
      (try (.close socket) (catch Exception _))
      port)))

(defn -main [& args]
  (let [port (or(env :port) (allocate-free-port!))
        app (-> config
                (assoc-in [:via/http-server :http-host] "0.0.0.0")
                (assoc-in [:via/http-server :http-port] port)
                ig/init)]
    (println (str "URL: http://0.0.0.0:" port))))
