(ns {{name}}.main
    (:require [clojure.java.io :refer [file]]
              [{{name}}.config :refer [config]]
              [config.core :refer [env]]
              [integrant.core :as ig])
    (:import [java.util Properties]
             [java.net ServerSocket]
             [io.netty.handler.ssl SslContextBuilder])
    (:gen-class))

(defn- allocate-free-port!
  []
  (let [socket (ServerSocket. 0)]
    (.setReuseAddress socket true)
    (let [port (.getLocalPort socket)]
      (try (.close socket) (catch Exception _))
      port)))

(defn -main [& args]
  (let [port (or (env :port) (allocate-free-port!))
        host (or (env :host) "0.0.0.0")
        cert-file (file (env :cert-file))
        key-file (file (env :key-file))
        ssl-context (when (and cert-file key-file)
                      (.build (SslContextBuilder/forServer cert-file key-file)))
        app (-> config
                (assoc-in [:via/http-server :http-host] host)
                (assoc-in [:via/http-server :http-port] port)
                (assoc-in [:via/http-server :ssl-context] ssl-context)
                ig/init)]
    (println "URL:" (str (if ssl-context "https" "http") "://" host ":" port))))
