(ns {{ns-name}}.components.alerts
  (:require [re-frame.core :as rf]
            [{{ns-name}}.shared-subs :as shared-subs]))

(defn alert-display []
  (let [alerts @(rf/subscribe [::shared-subs/alerts])]
    [:div#alerts
     (for [alert alerts]
       [:div.notification {:key (:uuid alert)
                           :class (str "is-" (:type alert))}
        (:message alert)])]))
