(ns {{ns-name}}.router
  (:require-macros [secretary.core :refer [defroute]])
  (:require [secretary.core                :as secretary]
            [re-frame.core                 :as rf]
            [{{ns-name}}.shared-subs      :as shared-subs]
            [{{ns-name}}.shared-events    :as shared-events]
            [{{ns-name}}.routes.index.view :as index]
            [{{ns-name}}.routes.other.view :as other]))

(defn app-routes []
  (secretary/set-config! :prefix "#")

  (defroute "/" []
    (rf/dispatch [::shared-events/set-active-route :index-route]))

  (defroute "/other" []
    (rf/dispatch [::shared-events/set-active-route :other-route])))

(defn get-route-template [route-name]
  (case route-name
    :index-route     [index/template]
    :other-route     [other/template]))

(defn active-route []
  (let [route (rf/subscribe [::shared-subs/active-route])]
    [get-route-template @route]))
