(ns leiningen.new.re-frame-scaffold
  (:use [leiningen.core.main :as main]
        [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]
        [clojure.string :as string]))

(def render (renderer "re-frame-scaffold"))

(defn java9? []
  (-> (System/getProperty "java.version")
      (string/split #"_")
      first
      (compare "9.0.0")
      (>= 0)))

(defn re-frame-scaffold
  [name]
  (let [data {:name      name
              :ns-name   (sanitize-ns name)
              :sanitized (name-to-path name)
              :java9?    (java9?)}]
    (main/info "=====\nBuilding your application...\n")
    (->files data
             ["README.md"                                  (render "README.md"                                      data)]
             [".gitignore"                                 (render ".gitignore"                                     data)]
             ["project.clj"                                (render "project.clj"                                    data)]
             ["dev/user.clj"                               (render "dev/user.clj"                                   data)]
             ["sass/site.scss"                             (render "sass/site.scss"                                 data)]
             ["src/{{sanitized}}/components/nav.cljs"      (render "src/re_frame_scaffold/components/nav.cljs"      data)]
             ["src/{{sanitized}}/components/alerts.cljs"   (render "src/re_frame_scaffold/components/alerts.cljs"   data)]
             ["src/{{sanitized}}/config.cljs"              (render "src/re_frame_scaffold/config.cljs"              data)]
             ["src/{{sanitized}}/core.cljs"                (render "src/re_frame_scaffold/core.cljs"                data)]
             ["src/{{sanitized}}/db.cljs"                  (render "src/re_frame_scaffold/db.cljs"                  data)]
             ["src/{{sanitized}}/shared_events.cljs"       (render "src/re_frame_scaffold/shared_events.cljs"       data)]
             ["src/{{sanitized}}/shared_subs.cljs"         (render "src/re_frame_scaffold/shared_subs.cljs"         data)]
             ["src/{{sanitized}}/router.cljs"              (render "src/re_frame_scaffold/router.cljs"              data)]
             ["src/{{sanitized}}/routes/index/db.cljs"     (render "src/re_frame_scaffold/routes/index/db.cljs"     data)]
             ["src/{{sanitized}}/routes/index/subs.cljs"   (render "src/re_frame_scaffold/routes/index/subs.cljs"   data)]
             ["src/{{sanitized}}/routes/index/events.cljs" (render "src/re_frame_scaffold/routes/index/events.cljs" data)]
             ["src/{{sanitized}}/routes/index/view.cljs"   (render "src/re_frame_scaffold/routes/index/view.cljs"   data)]
             ["src/{{sanitized}}/routes/other/view.cljs"   (render "src/re_frame_scaffold/routes/other/view.cljs"   data)]
             ["src/{{sanitized}}/routes/other/events.cljs" (render "src/re_frame_scaffold/routes/other/events.cljs" data)]
             ["src/{{sanitized}}/interceptors.cljs"        (render "src/re_frame_scaffold/interceptors.cljs"        data)]
             ["src/{{sanitized}}/utils/helpers.cljs"       (render "src/re_frame_scaffold/utils/helpers.cljs"       data)]
             ["test/{{sanitized}}/index_test.cljs"         (render "test/re_frame_scaffold/index_test.cljs"         data)]
             ["test/{{sanitized}}/other_test.cljs"         (render "test/re_frame_scaffold/other_test.cljs"         data)]
             ["test/{{sanitized}}/runner.cljs"             (render "test/re_frame_scaffold/runner.cljs"             data)]
             ["resources/public/index.html"                (render "resources/public/index.html"                   data)])
    (main/info "You are good to go!\n=====")))
