(ns {{ns-name}}.components.alerts
  (:require [re-frame.core :as rf]
            [{{ns-name}}.utils.helpers :refer [<sub]]
            [{{ns-name}}.shared-subs :as shared-subs]))

(defn alert-display []
  (let [alerts (<sub [::shared-subs/alerts])]
    [:div#alerts
     (for [alert alerts]
       [:div.notification {:key (:uuid alert)
                           :class (str "is-" (:type alert))}
        (:message alert)])]))
