(ns {{ns-name}}.core
  (:import goog.History)
  (:require [{{ns-name}}.components.nav :refer [nav-bar]]
            [{{ns-name}}.components.alerts :refer [alert-display]]
            [reagent.core :as reagent]
            [goog.events :as gevents]
            [goog.history.EventType :as EventType]
            [secretary.core :as secretary]
            [re-frame.core :as rf]
            [{{ns-name}}.utils.helpers :refer [<sub]]
            [{{ns-name}}.shared-subs :as shared-subs]
            [{{ns-name}}.shared-events :as shared-events]
            [{{ns-name}}.router :as router]
            [{{ns-name}}.config :as config]
            [day8.re-frame.http-fx]))

(defn dev-setup []
  (when config/debug?
    (enable-console-print!)
    (println "dev mode")))

(defn hook-browser-navigation! []
  (doto (History.)
    (gevents/listen
     EventType/NAVIGATE
     (fn [event]
       (secretary/dispatch! (.-token event))))
    (.setEnabled true)))

(defn app []
  (let [ready? (<sub [::shared-subs/initialised?])]
    (if-not ready?
      [:div "Initialising ..."]
      [:div#container
       [nav-bar]
       [alert-display]
       [router/active-route]])))

(defn mount-app []
  (rf/clear-subscription-cache!)
  (reagent/render (app) (.getElementById js/document "app")))

(defn ^:export main []
  (dev-setup)
  (router/app-routes)
  (rf/dispatch-sync [::shared-events/initialize-db])
  (hook-browser-navigation!)
  (mount-app))
