(ns {{ns-name}}.routes.other.events
  (:require [re-frame.core :as rf]
            [{{ns-name}}.shared-events :as shared-events]
            [{{ns-name}}.config :as config]
            [{{ns-name}}.interceptors :refer [standard-interceptors]]))

(rf/reg-event-fx
  ::sound-alert
  [(rf/inject-cofx ::shared-events/uuid) standard-interceptors]
  (fn [{:keys [uuid]} _]
    {:dispatch [::shared-events/add-alert uuid "AN ALERT HAS BEEN ISSUED" "danger"]
     :dispatch-later [{:ms config/alert-timeout-ms
                       :dispatch [::shared-events/remove-alert uuid]}]}))
