(ns {{ns-name}}.shared-events
  (:require [{{ns-name}}.interceptors :refer [standard-interceptors]]
            [{{ns-name}}.utils.helpers :as helpers]
            [re-frame.core :as rf]
            [{{ns-name}}.db :as db]))

; = Register CoFx ==============================================================

; Usage: When registering a event (rf/inject-cofx ::uuid) as an interceptor
; Description: A cofx to inject a uuid into the event.
(rf/reg-cofx
  ::uuid
  (fn [coeffects _]
    (assoc coeffects :uuid (random-uuid))))

; === Register Events ==========================================================
(rf/reg-event-db
  ::initialize-db
  [standard-interceptors]
  (fn [_ _]
    db/default-db))

(rf/reg-event-db
  ::set-active-route
  [standard-interceptors]
  (fn [db [_ active-route]]
    (assoc db :active-route active-route)))

; -- Alerts --------------------------------------------------------------------

; Usage: ::add-alert and ::remove-alert are typically used at the same time.
;        In a reg-event-fx like so:
;        {:dispatch       [::add-alert (:uuid cofx) "Alert body here" "Alert Type ie: danger, info, etc"]
;         :dispatch-later [{:ms config/alert-timeout-ms
;                           :dispatch [::remove-alert (:uuid cofx)]}]}
; Description: Extends the top level `:alerts` vector with a alert map {:uuid #uuid :type "..." :message "..."}
(rf/reg-event-db
  ::add-alert
  [standard-interceptors]
  (fn [db [_ uuid message alert-type]]
    (update db :alerts merge {:uuid uuid :message message :type alert-type})))

; Description: Removes the alert with the matching uuid from the top-level
;              `:alerts` vector. See above for additional detail
(rf/reg-event-db
  ::remove-alert
  [standard-interceptors]
  (fn [db [_ uuid]]
    (update db :alerts helpers/remove-matching-uuid uuid)))
