(ns {{ns-name}}.index-test
  (:require [cljs.test :refer-macros [deftest testing is]]
            [day8.re-frame.test :as rf-test]
            [{{ns-name}}.events :as shared-events]
            [{{ns-name}}.routes.index.events :as sut-events]
            [{{ns-name}}.routes.index.subs :as sut-subs]
            [goog.string :as gstring]
            [re-frame.core :as rf]))

(deftest getting-and-setting-hex-color
  (rf-test/run-test-sync
    (rf/dispatch [::shared-events/initialize-db])
    (let [color      (rf/subscribe [::sut-subs/get-color])
          spec-error "spec check failed: In: [:index-route :hex-color]"]
      (is (= "#3E3E3E" @color))
      (rf/dispatch [::sut-events/set-color "#3E3E3"])
      (is (= "#3E3E3" @color))
      (try (rf/dispatch [::sut-events/set-color "#3E3E3XX"])
           (catch js/Error e (is (gstring/startsWith (.-message e) spec-error)))))))
