(ns babbage.tst
  (:require [babbage.core :as b]
            [babbage.provided.core :as p]
            [babbage.monoid :as m]
            [babbage.functors :as tf]
            [clojure.algo.generic.functor :as f]))

(def f (fn ([a b] (m/<> a b)) ([] nil)))

(defn calculate [input]
  (b/calculate (b/sets) (b/stats :x p/sum) input))

(defn r-calculate [input]
  (b/r-calculate (b/sets) (b/stats :x p/sum) input))

(defn simple-calculate [input]
  (m/value (reduce m/<> (pmap (comp p/m-sum :x) input))))

#_(defn r-simple-calculate [input]
  (m/value (r/fold f m/<> (r/map (comp p/m-sum :x) input))))

(def sf ((b/sets) (b/stats :x p/sum)))

(def xs (doall (map (fn [x] {:x x}) (range 100000))))


