(ns borg.borglet.state
  (:require [borg.borglet.handler.core :as h])
  (:import java.util.UUID))

(def state (atom {}))

(h/defhandler getm
  "Get multiple keys as a map.
   Ex: (do :getm {:keys [:a :b :c]}) -> {:a 0 :b 1 :c 2}"
  [options]
  (->> (:keys options)
       (map keyword)
       (select-keys @state)))

(h/defauthedhandler set
  "Set a key(s) to a value(s).
   Ex: (do :set {:values {:a 1 :b 2}})"
  [options]
  (swap! state merge (:values options))
  true)

(h/defauthedhandler delete
  "Delete key(s).
   Ex: (do :delete {:keys [:a :b :c]})"
  [options]
  (->> (:keys options)
       (map keyword)
       (apply swap! state dissoc))
  true)

(defn add-listener [func]
  (add-watch state (keyword (UUID/randomUUID)) func))