;; owner: marshall@readyforzero.com
;; Get tags from an ec2 instance.

(ns borg.aws.ec2
  (:require [borg.aws.core :as aws]
            [borg.internal.lang :refer [-?>]]
            [clj-http.client :as http])
  (:import com.amazonaws.services.ec2.AmazonEC2Client
           com.amazonaws.services.ec2.model.DescribeInstancesRequest))

(defn instance-id []
  (->> (http/get "http://169.254.169.254/latest/meta-data/instance-id")
       (:body)))

(defn instance-tags
  "Get the tags associated with an ec2 instance as a map."
  [instance-id]
  (-?> (aws/get-credentials)
       (AmazonEC2Client.)
       (.describeInstances (-> (DescribeInstancesRequest.)
                               (.withInstanceIds [instance-id])))
       (.getReservations)
       (first)
       (.getInstances)
       (first)
       (.getTags)
       (->> (map #(vector (.getKey %) (.getValue %)))
            (into {}))))

(defn get-tags
  "Get a list of the values of the specified tags for
   an instance. If the value is nil it won't be included
   in the list."
  ([tags] (get-tags tags (instance-id)))
  ([tags instance]
     (if-let [tags-map (instance-tags instance)]
       (->> (map #(get instance-tags %) tags)
            (keep identity)))))
