(ns borg.borglet.handler.handlers
  (:require [borg.config :as config]
            [borg.borglet.handler.core :as h]
            [borg.borglet.util.io :as io]))

;; Options is a map with keys
;; *required*
;; :command the bash command to run
;; *optional*
;; All the rest of the keys are the same as clojure.java.shell/sh
;; with the exception that all supplied values from the client side must
;; be serializable (no streams).
(h/defhandler shell [options]
  (let [re (io/sh h/*user*
                  (:command options)
                  (dissoc options :command))]
    (if (not= 0 (:exit re))
      (h/make-error (str "Exit: " (:exit re) ". " (:err re)))
      re)))

;; returns the user this command was executed as
(h/defhandler user [options]
  (config/get [:user] "root"))
