;; Owner: wolfson@readyforzero.com
;; Implementation for the package node type.
;; Install a package on the system, using the first package manager it
;; knows about that's installed on the system.
;; Very unsophisticated: tries to install the package if the requested
;; version isn't already installed, otherwise does nothing.
(ns borg.state.types.package
  (:require [borg.state.graph :as g]
            [borg.state.types.packages.core :as packages]
            [borg.state.types.packages.protocol :as iface])
  (:use [borg.state.types.core :only [defop node-path defnodefn]]))

;; this is basically the stupidest possible approach.
(defnodefn install? [version installed-version]
  (not= version installed-version))

(defnodefn install [pkgname version]
  (iface/install! @packages/manager pkgname version))

(defmethod g/check-node "package" [node _ _]
  ((node-path install? => install) node))

(defmethod g/from-wire "package" [node]
  (assoc-in node [:attrs :installed-version]
            (iface/get-installed-version @packages/manager (g/node-attr node :pkgname))))
