(ns borg.state.types.packages.protocol
  (:require [clojure.string :as str]
            [me.raynes.fs :as fs]))

(defn get-path []
  (str/split (System/getenv "PATH") #":"))

(defn on-path? [binary]
  (some fs/exists? (map #(str % "/" binary) (get-path))))

(defprotocol PackageManager
  (installed? [self]
    "Return true if the package manager is installed on the system.")
  (get-installed-version [self package-name]
    "Return a textual representation of the currently installed version of package-name.")
  (install! [self package-name version]
    "Return a representation of an action that will install the package at the requested version."))
