;; owner: marshall@readyforzero.com
;; Functions for setting the type of transport to use,
;; starting the server, and connecting to a server.
;;
;; -- Config --
;; Key :transport
;; Sub-keys
;; :type - (string) transport type (ex: http, virtual), default http.
;; :options - (map) options that will be passed to the transport init
;;            function.

(ns borg.transport.core
  (:require [borg.internal.module :as m]
            [borg.transport.interface :as in]
            [borg.transport.http :as http]
            [borg.transport.virtual :as virtual]
            [clojure.tools.logging :as lg]))

;; see borg.internal.module for behavior
(m/create-vars {:http http/init
                :virtual virtual/init})

(defn add-transport-type! [key fn]
  (m/add-type key fn))

(defn get-transport []
  (m/get-instance :transport :http {}))

(defn set-transport!
  [t & [options]]
  (m/set-instance t options))
;; end module section

(defn borglet-start [handler-executer port]
  (in/start-server (get-transport) handler-executer port))

(defn borglet-stop [borglet]
  (in/stop-server (get-transport) borglet))

(defn client-create [host port]
  (in/create-client (get-transport) host port))

(defn client-close [client]
  (in/close-client (get-transport) client))

(defn run-handler [client handler options]
  (in/send-command (get-transport)
    client
    {:handler handler
     :options options}))
