(ns buckshot.worker
  (:require [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [clojure.stacktrace :as st]))

(defprotocol IWorker
  (start! [this])
  (stop! [this]))

(defrecord Worker [id fns queue active?]
  IWorker
  (start! [this]
    (when-not @active?
      (reset! active? true)
      (future
        (while @active?
          (try (let [j (queue/next-job queue (keys fns))
                     f (get fns (:fn j))]
                 (when (and f (queue/take-job! queue j))
                   (let [result (apply f this (:args j))]
                     (queue/publish! queue (:id j) result)
                     (queue/finish-job! queue j))))
               (catch Throwable t
                 (let [s (with-out-str (st/print-stack-trace t))]
                   (buckshot/log! queue id s))))
          (Thread/sleep 1000)))))
  (stop! [_]
    (reset! active? false)))

(defn make [{:keys [id fns queue] :as params}]
  (let [w (Worker. id fns queue (atom false))]
    (start! w)
    w))
