(ns buckshot.util
  (:require [clj-time.coerce :as tc]
            [clj-time.core :as time]))

(defn ->period [[x unit]]
  (case unit
    :year   (time/years x)
    :month  (time/months x)
    :week   (time/weeks x)
    :day    (time/days x)
    :hour   (time/hours x)
    :minute (time/minutes x)
    :second (time/seconds x)
    :milli  (time/millis x)))

(defn ->millis [[x unit]]
  (-> [x unit] ->period (.toStandardDuration) (.getMillis)))

(defn make-id []
  (str (java.util.UUID/randomUUID)))

(defn make-job [now fn & [opts]]
  {:args (:args opts)
   :created now
   :fn fn
   :from (.getHostName (java.net.InetAddress/getLocalHost))
   :id (or (:id opts) (make-id))
   :period (:period opts)
   :queue (or (:queue opts) :default)
   ;; use later of now and :start (if present)
   :start (max now (-> opts :start (or 0) tc/to-long))})
