(in-ns 'buckshot.backend)

(def data (ref {}))

(def subscribers (atom {}))

(defrecord InMemoryBackend []
  IBackend
  (get-colls [_]
    (keys @data))
  (get-all [_ coll]
    (->> (get @data coll)
         (map :item)))
  (get-min [_ coll max]
    (->> (get @data coll)
         (filter #(-> % :score (<= max)))
         (sort-by :score)
         first
         :item))
  (has-item? [_ coll item]
    (->> (get @data coll)
         (map :item)
         (some #{item})))
  (has-score? [_ coll score]
    (->> (get @data coll)
         (map :score)
         (some #{score})))
  (atomically [_ f]
    (dosync (f)))
  (add! [this coll score item]
    (when-not (has-item? this coll item)
      (alter data update-in [coll] conj {:score score :item item})))
  (remove! [this coll item]
    (when (has-item? this coll item)
      (let [match? #(-> % :item (= item))]
        (alter data update-in [coll] #(remove match? %)))))
  (delete! [_ coll]
    (when (get @data coll)
      (alter data dissoc coll)))
  (publish! [_ channel message]
    (doseq [f (get @subscribers channel)]
      (f message)))
  (subscribe! [_ channel f]
    (swap! subscribers update-in [channel] conj f)))

(defn make-in-memory [params]
  (InMemoryBackend.))
