(ns buckshot.demo
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]))

;; init
(def backend (backend/make-in-memory {}))

(def queue (queue/make {:backend backend}))

(buckshot/add-log-handler! queue println)

(def worker (worker/make {:id "worker 1"
                          :fns {:add (fn [w j] (apply + (:args j)))
                                :bad (fn [w j] (throw (Exception. "bad")))
                                :schedule-jobs tasks/schedule-jobs!}
                          :queue queue}))

(defn status-check []
  (println "specs:" (queue/specs queue))
  (println "scheduled:" (queue/scheduled queue))
  (println "processing:" (queue/processing queue)))

;; one-time task
(queue/subscribe! queue "good" #(buckshot/log! queue "result:" %))

(queue/add-specs! queue [{:id "good"
                          :fn :add
                          :args [1 1]}])

(queue/schedule-jobs! queue)

;; task exception
(queue/add-specs! queue [{:id "bad"
                          :fn :bad}])

(queue/schedule-jobs! queue)

(->> (queue/processing queue)
     first
     (queue/finish-job! queue))

;; recurring task
(queue/add-specs! queue [{:id "schedule jobs"
                          :fn :schedule-jobs
                          :period :second}])

(queue/schedule-jobs! queue)

(worker/stop! worker)

(->> (queue/specs queue)
     first
     (queue/remove-spec! queue))

(worker/start! worker)

;; unknown job should not block everything
(queue/add-specs! queue [{:id "ugly"
                          :fn :unknown}
                         {:id "good"
                          :fn :add
                          :args [2 2]}])

(queue/schedule-jobs! queue)

(->> (queue/specs queue)
     first
     (queue/remove-spec! queue))

(status-check)
