(ns buckshot.test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def pool (redis/make-conn-pool))

(def spec (redis/make-conn-spec
           :host "10.0.36.177"
           ))

(defmacro wredis [& body] `(redis/with-conn pool spec ~@body))

(-> (wredis (redis/client-list))
    (clojure.string/split #"\n")
    count
;;    clojure.pprint/pprint
    )

(def right (atom 0))

(def wrong (atom 0))

(def q (let [b (backend/make-redis {:host "10.0.36.177"})]
         (queue/make {:backend b})))

(doseq [i (range 400)]
  (future
    (println i)
    (let [test-id (str i)
          xs (repeat 50 1)
          answer (str (apply + xs))]
      (queue/subscribe! q
                        test-id
                        (fn [result]
                          (if (= answer result)
                            (swap! right inc)
                            (swap! wrong inc))))
      (queue/add-spec! q {:id test-id
                          :fn :stress-test
                          :args xs}))))
