(ns buckshot.test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def pool (redis/make-conn-pool))

(def spec (redis/make-conn-spec
;;           :host "10.0.36.177"
           ))

(defmacro wredis [& body] `(redis/with-conn pool spec ~@body))

(-> (wredis (redis/client-list))
    (clojure.string/split #"\n")
    count
;;    clojure.pprint/pprint
    )

(def right (atom 0))

(def wrong (atom 0))

(def q (let [b (backend/make-redis {})]
         (queue/make {:backend b})))

(def specs (for [i (range 200)]
             {:id (str i)
              :fn :stress-test
              :args (repeat 50 1)}))

(doseq [s specs]
  (queue/subscribe! q
                    (:id s)
                    (fn [result]
                      (if (= result "50")
                        (swap! right inc)
                        (swap! wrong inc)))))

(queue/add-specs! q specs)

(queue/schedule-jobs! q)
