(ns buckshot.test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def pool (redis/make-conn-pool :max-active -1
                                :max-idle -1))

(def spec (redis/make-conn-spec))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

(comment
  (-> (wredis (redis/client-list))
      (clojure.string/split #"\n")
      count
      clojure.pprint/pprint))

(wredis (redis/flushall))

(def results (atom nil))

(def q (let [b (backend/make-redis {})]
         (queue/make {:backend b})))

(def specs (for [i (range 1000)]
             {:id (str i)
              :fn :stress-test
              :args [1]}))

(doseq [{:keys [id args]} specs]
  (queue/subscribe! q
                    id
                    (fn [result]
                      (swap! results conj id))))

(queue/add-specs! q specs)

(queue/schedule-jobs! q)
