(ns buckshot.test2
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def q (queue/make {:backend (backend/make-redis {})}))

(buckshot/add-log-handler! q println)

(queue/add-specs! q [{:id "schedule jobs"
                      :fn :schedule-jobs
                      :period :second}])

(defn- stress-test [worker job]
  (apply + (:args job)))

(doseq [i (range 8)]
    (worker/make {:id (str "worker " i)
                  :fns {:schedule-jobs tasks/schedule-jobs!
                        :stress-test stress-test}
                  :queue q}))
