(ns buckshot.core
  (:require [buckshot.queue :as queue]
            [clojure.string :as str]))

(defn add-log-handler! [queue f]
  (queue/subscribe! queue :log f))

(defn log! [queue & args]
  (let [now (java.util.Date.)
        thread-name (.getName (Thread/currentThread))
        tokens (concat [now thread-name] args)]
    (queue/publish! queue :log (str/join " " tokens))))
