(ns buckshot.worker
  (:require [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [clojure.stacktrace :as st]))

(defprotocol IWorker
  (start! [this])
  (stop! [this]))

(defrecord Worker [id fns queue active?]
  IWorker
  (start! [this]
    (when-not @active?
      (reset! active? true)
      (future
        (while @active?
          (try (if-let [j (queue/next-job queue (keys fns))]
                 (if (queue/take-job! queue j)
                   (let [f (-> j :fn fns)]
                     (buckshot/log! queue id "started" (:id j))
                     (queue/publish! queue (:id j) (f this j))
                     (queue/finish-job! queue j)
                     (buckshot/log! queue id "finished" (:id j))
                     (Thread/sleep 500))
                   (Thread/sleep (rand-int 1000)))
                 (Thread/sleep (* 10 60 1000)))
               (catch Throwable t
                 (let [trace (with-out-str (st/print-stack-trace t))]
                   (buckshot/log! queue id trace))))))))
  (stop! [_]
    (reset! active? false)))

(defn make [{:keys [id fns queue] :as params}]
  (let [w (Worker. id fns queue (atom false))]
    (start! w)
    w))
