(ns buckshot.core
  (:require [buckshot.queue :as queue]
            [buckshot.util :as util]
            [clojure.string :as str]))

(defn add-log-handler! [queue f]
  (queue/subscribe! queue :log f))

(defn log! [queue data]
  (queue/publish! queue :log (assoc data
                               :date (str (java.util.Date.))
                               :timestamp (util/now-ms)
                               :thread (.getName (Thread/currentThread)))))
