(ns buckshot.core
  (:require [buckshot.queue :as queue]
            [buckshot.util :as util]
            [clojure.string :as str]))

(defn add-log-handler! [queue f]
  (queue/subscribe! queue :log f))

(defn log! [queue data]
  (queue/publish! queue :log (assoc data
                               :date (str (java.util.Date.))
                               :timestamp (util/now-ms)
                               :thread (.getName (Thread/currentThread)))))

(defn- rand-id [fn-name args]
  (str (name fn-name) ":"
       (hash args) ":"
       "<hostname>" ":"
       (System/currentTimeMillis) ":"
       (java.util.UUID/randomUUID)))

(defn send! [queue fn-name args & options]
  (let [options (apply hash-map options)
        id (or (:id options) (rand-id fn-name args))
        cb (:callback options)
        p (when-not (contains? options :callback)
            (promise))]
    (queue/subscribe! queue id (fn [r]
                                 (cond cb (cb r)
                                       p (deliver p r))))
    (queue/add-spec! queue {:id id
                            :start-time (:start-time options)
                            :fn fn-name
                            :args args
                            :period (:period options)})
    p))
