(ns test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.tasks :as tasks]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def pool (redis/make-conn-pool))

(def spec (redis/make-conn-spec :host "10.0.56.105"))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

(wredis (redis/keys "*"))

(wredis (redis/hgetall "one-time"))

(wredis (redis/hgetall "recurring"))

(wredis (redis/zrange "schedule-jobs" 0 -1))

(wredis (redis/zrange "send-js-errors" 0 -1))

(wredis (redis/zrange "schedule-log-logins" 0 -1))

(wredis (redis/zrange "processing" 0 -1))
