(ns test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

;;(def host "10.0.36.17")
(def host "10.0.56.105")
;;(def host "127.0.0.1")

(def pool (redis/make-conn-pool))

(def spec (redis/make-conn-spec :host host))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

;;(wredis (redis/flushall))

(def ks (-> (wredis (redis/keys "*"))
            set
            (disj "one-time" "recurring")
            sort))

(for [k ks]
  [k (wredis (redis/zcard k))])

(wredis (redis/hlen "one-time"))

(wredis (redis/zcard "notification-listener"))

(wredis (redis/zcard "processing"))

(def b (backend/make-redis {:host host}))

(def q (queue/make {:backend b}))

(def j (wredis (redis/hget "one-time" "notification-listener:-401511147:<hostname>:1361689264893:085bc90c-bf22-4a8a-87bd-5d9d5ed5d9de")))

(def j {:id "notification-listener:-401511147:<hostname>:1361689264893:085bc90c-bf22-4a8a-87bd-5d9d5ed5d9de", :start-time 1361689264893, :fn :notification-listener, :args [{:notifo :payment-due, :user 37497, :channel-keys [:email :web :mobile :mobile-push :console], :context {:to-send '([100708 {:statement {:dueDate 1362182400000, :planned 219.64M, :account_id 100708, :minPayment 4.39, :paidOverride nil, :paid false, :apr 13.24M, :id 683161, :amountDue 4.39M}, :late false, :account_id 100708, :payments '(), :already-paid 0, :planned 380.5314127499327, :suggested-remaining 380.5314127499327}])}} true], :period nil})

(wredis (redis/del "benny"))

(def x (array-map :a 1 :b 2 :c 3 :d 4 :e 5 :f 6 :g 7 :h 8 :i 9 :j 10))
(def x (hash-map :a 1 :b 2 :c 3 :d 4 :e 5 :f 6 :g 7 :h 8 :i 9 :j 10))
(def x (sorted-map :a 1 :b 2 :c 3 :d 4 :e 5 :f 6 :g 7 :h 8 :i 9 :j 10))

(type x)

(wredis (redis/zadd "benny" 0 x))

(let [x (first (wredis (redis/zrange "benny" 0 0)))]
  (println (type x))
  (wredis (redis/zrank "benny" x)))
