(ns test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [clj-time.core :as time]
            [clojure.pprint :as pp]
            [taoensso.carmine :as redis]))

;;(def host "10.0.36.17")
(def host "10.0.56.105")
;;(def host "127.0.0.1")

(def pool (redis/make-conn-pool))

(def spec (redis/make-conn-spec :host host))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

;;(wredis (redis/flushall))

(wredis (redis/hlen "one-time"))

(def ks (-> (wredis (redis/keys "*"))
            set
            (disj "one-time" "recurring")
            sort))

(for [k ks]
  [k (wredis (redis/zcard k))])

(def b (backend/make-redis {:host host}))

(def q (queue/make {:backend b}))
