(in-ns 'buckshot.backend)

(def data (ref {}))

(def subscribers (atom {}))

(defrecord InMemoryBackend []
  IBackend
  (colls [_]
    (keys @data))
  (atomically [_ colls f]
    (dosync (f)))
  (hall [_ hash]
    (-> (get @data hash)
        vals))
  (hget [_ hash key]
    (get-in @data [hash key]))
  (hadd! [_ hash key value]
    (alter data assoc-in [hash key] value))
  (hrem! [_ hash key]
    (alter data update-in [hash] dissoc key))
  (zall [_ set]
    (->> (get @data set)
         (map :value)))
  (zmin [_ set max-key]
    (->> (get @data set)
         (filter #(-> % :key (<= max-key)))
         (sort-by :key)
         first
         :value))
  (zexists? [_ set value]
    (->> (get @data set)
         (map :value)
         (some #{value})))
  (zadd! [this set key value]
    (zrem! this set value)
    (alter data update-in [set] conj {:key key :value value}))
  (zrem! [this set value]
    (let [match? #(-> % :value (= value))]
      (alter data update-in [set] #(remove match? %))))
  (publish! [_ channel message]
    (doseq [f (get @subscribers channel)]
      (f message)))
  (subscribe! [_ channel f]
    (swap! subscribers update-in [channel] conj f)))

(defn make-in-memory [params]
  (InMemoryBackend.))
