(ns buckshot.demo
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.util :as util]
            [buckshot.worker :as worker]))

;; init
(def b (backend/make-in-memory {}))

(def q (queue/make {:backend b}))

(buckshot/add-log-handler! q println)

(def worker-fns
  {:add (fn [& xs] (apply + xs))
   :bad #(throw (Exception. "bad"))
   :recur #(buckshot/send! q :recur nil :period [3 :second] :callback nil)})

(def worker (worker/make {:id 0 :fns worker-fns :queue q}))

(defn status-check []
  (println "jobs:" (backend/hall b :jobs))
  (println "scheduled:" (->> (backend/colls b)
                             (remove #{:jobs :processing})
                             (mapcat #(backend/zall b %))))
  (println "processing:" (backend/zall b :processing)))

(status-check)

;; one-time job
(def p (buckshot/send! q :add [1 1]))

(deref p)

;; job exception
(buckshot/send! q :bad nil)

(->> (backend/hall b :jobs)
     first
     (queue/finish-job! q))

;; recurring job
(queue/add-job! q {:id "recur"
                   :fn :recur})

(worker/stop! worker)

(->> (backend/hall b :jobs)
     first
     (queue/remove-job! q))

(worker/start! worker)

;; unknown job should not block everything
(buckshot/send! q :unknown nil)

(def p (buckshot/send! q :add [1 2 3]))

(deref p)

(->> (backend/hall b :jobs)
     first
     (queue/remove-job! q))

(status-check)
