(ns buckshot.core
  (:require [buckshot.queue :as queue]
            [buckshot.util :as util]))

(defn add-log-handler! [queue f]
  (queue/subscribe! queue :log f))

(defn log! [queue data]
  (queue/publish! queue :log (assoc data
                               :date (str (java.util.Date.))
                               :timestamp (util/now-ms))))

(defn send! [queue fn args & options]
  (let [options (apply hash-map options)
        id (or (:id options) (util/rand-id))
        cb (:callback options)
        ;; Allow "nil" to be specified as the callback, which means no promise.
        p (when-not (contains? options :callback)
            (promise))]
    (cond
     cb (queue/subscribe! queue id cb)
     p  (queue/subscribe! queue id #(deliver p %)))
    (queue/add-job! queue {:id id
                           :fn fn
                           :args args
                           :start (:start options)
                           :period (:period options)})
    p))
