(ns test
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [clojure.pprint :as pp]
            [taoensso.carmine :as redis]))

;;(def host "10.0.36.17") ;; stage
(def host "10.0.56.105") ;; prod
;;(def host "127.0.0.1") ;; local

;; master
(def conn {:spec {:host host}})

(defmacro wredis [& body]
  `(redis/wcar conn ~@body))

;; 0.6.x
(def pool (redis/make-conn-pool))

(def spec (redis/make-conn-spec :host host))

(defmacro wredis [& body]
  `(redis/with-conn pool spec ~@body))

;;(wredis (redis/flushall))

(wredis (redis/hlen "one-time"))

(wredis (redis/hkeys "recurring"))

(def ks (-> (wredis (redis/keys "*"))
            set
            (disj "one-time" "recurring")
            sort))

(pprint (for [k ks]
          [k (wredis (redis/zcard k))]))

(wredis (redis/zcard "processing"))

(def b (backend/make-redis {:host host}))

(def q (queue/make {:backend b}))

(doseq [j (->> (wredis (redis/zrange "processing" 0 -1))
               (filter #(-> % :fn #{:citi-analytics})))]
  (do (wredis (redis/hdel "one-time" (:id j)))
      (wredis (redis/zrem "processing" j))))
