(ns playground
  (:require [buckshot.backend :as backend]
            [buckshot.core :as buckshot]
            [buckshot.queue :as queue]
            [buckshot.util :as util]
            [buckshot.worker :as worker]
            [taoensso.carmine :as redis]))

(def host "10.0.56.105") ;; prod
;;(def host "10.0.36.17") ;; stage
;;(def host "127.0.0.1") ;; local

(defmacro wredis [& body]
  `(redis/wcar {:spec {:host host}} ~@body))

;; 0.7.x
(def q (queue/make {:backend (backend/make-redis {:host host})}))

;; all scheduled job types
(->> (wredis (redis/keys "buckshot:*"))
     (sort)
     (pprint))

;; all job ids
(->> (wredis (redis/hkeys "buckshot:jobs"))
     (sort)
     (pprint))

;; job ids by type
(->> (wredis (redis/zrange "buckshot:run-biller" 0 -1))
     (pprint))

;; processing job ids
(->> (wredis (redis/zrange "buckshot:processing" 0 -1))
     (pprint))

;; get job
(-> (wredis (redis/hget "buckshot:jobs" "afternoon payee report"))
    (update-in [:start] #(java.util.Date. %))
    (pprint))
