(ns buckshot.scheduler.simple
  (:require [buckshot.scheduler :as scheduler]))

(defrecord SimpleScheduler [fn-map opts]
  scheduler/IScheduler
  (add-job! [_ fn {:keys [args period start] :as job-opts}]
    (cond
     ;; no support for recurring jobs
     period nil

     ;; no support for later start time
     start nil

     :else (if-let [f (get fn-map fn)]
             (apply f (:args job-opts))
             (throw (Exception. (str "Unknown job fn: " fn))))))
  (del-job! [_ _]
    nil)
  (start! [_]
    true)
  (stop! [_]
    true))

(defn make
  "Makes a simple Buckshot scheduler. Intended for certain types of tests.

  Runs jobs and returns results directly. Currently does not support recurring
  or future jobs, which are dropped silently. Since there's no backend, pub-sub
  functionality such as enqueue-p! are also not supported.

  'opts' may contain the following:

  :fn-map - a map of keys to job functions, which may have arbitrary arity.
            See buckshot.test.core for examples."
  [opts]
  (let [{:keys [fn-map]} opts]
    (->SimpleScheduler fn-map opts)))
