(ns {{ name }}.utils)

(defn mapmap
  "Return a new map, mapping keys to (keyfn key) and mapping values to
  (valfn val)

  Inspired/stolen from http://tech.puredanger.com/2010/09/24/meet-my-little-friend-mapmap/
  "
  ([valfn seq]
   (mapmap identity valfn seq))
  ([keyfn valfn seq]
   (persistent! (reduce
                 (fn [c v] (assoc! c (keyfn v) (valfn v)))
                 (transient {})
                 seq))))

(defn add-shutdown-hook!
  "Adds a shutdown hook to the JVM runtime.

  `f` is a function that takes 0 arguments; the return value is ignored.  This
  function will be called if the JVM receiveds an interrupt signal (e.g. from
  `kill` or CTRL-C); you can use it to log shutdown messages, handle state
  cleanup, etc."
  [^Runnable f]
  {:pre [(fn? f)]}
  (.addShutdownHook (Runtime/getRuntime) (Thread. f)))
