(def project '{{ name }})
(def version "0.1.0-SNAPSHOT")

(set-env!
  :resource-paths #{"resources" "src"}
  :source-paths   #{"test"}
  :wagons '[[s3-wagon-private "1.2.0"]]
  :repositories #(conj % ["recursion" {:url "s3p://recursion-jars/"
                                       :username (System/getenv "AWS_ACCESS_KEY_ID")
                                       :passphrase (System/getenv "AWS_SECRET_ACCESS_KEY")}])
  :dependencies
  '[[org.clojure/clojure "1.9.0-alpha17" :scope "provided"]

    ;; Logging Dependencies
    [org.clojure/tools.logging "0.4.0"]
    [com.google.cloud/google-cloud-logging-logback "0.30.0-alpha"]
    [net.logstash.logback/logstash-logback-encoder "4.11"]
    {{#postgres}}

    ;; Postgres Dependencies
    [org.clojure/java.jdbc "0.7.3"]
    [hikari-cp "1.8.2"]
    [nilenso/honeysql-postgres "0.2.3"]
    [org.postgresql/postgresql "42.1.4"]
    {{/postgres}}
    {{#web}}

    ;; Web Dependecies
    [com.recursionpharma/http-server "0.1.1"]
    [metosin/compojure-api "2.0.0-alpha7"]
    [ring-logger "0.7.7"]
    {{/web}}

    ;; Application Dependencies
    [clj-time "0.14.0"]
    [com.stuartsierra/component "0.3.2"]
    [medley "1.0.0"]
    [metosin/spec-tools "0.3.3"]
    [sonian/carica "1.2.2"]

    ;; Test/Development Dependencies
    [org.clojure/test.check "0.10.0-alpha2" :scope "test"]
    [com.gfredericks/test.chuck "0.2.8" :scope "test"]
    {{#web}}
    [clj-http "3.7.0" :scope "test"]
    [ring/ring-mock "0.3.1" :scope "test"]
    {{/web}}

    ;; Boot tasks
    [adzerk/boot-test "1.2.0" :scope "test"]
    {{#postgres}}
    [mbuczko/boot-ragtime "0.3.0" :scope "test"]
    {{/postgres}}
    [onetom/boot-lein-generate "0.1.3" :scope "test"]])

(require '[adzerk.boot-test :refer [test]]
         '[boot.lein]{{#postgres}}
         '[mbuczko.boot-ragtime :refer [ragtime]]{{/postgres}})

(task-options!
 aot {:all true}
 pom {:project     project
      :version     version
      :description "FIXME: write description"
      :url         "https://github.com/recursionpharma/{{ name }}"
      :scm         {:url "https://github.com/recursionpharma/{{ name }}"}}
 jar {:main '{{ name }}.core
      :file "{{ name }}-standalone.jar"}{{#postgres}}
 ragtime {:database "jdbc:postgresql://localhost:5432/{{ name }}"
          :directory "resources/migrations"}{{/postgres}})

(defn dev-env! []
  (merge-env! :source-paths #{"dev"}))

(replace-task! [r repl]
  (fn [& xs]
    (dev-env!)
    (apply r xs)))

(replace-task! [t test]
  (fn [& xs]
    (dev-env!)
    (apply t xs)))

(deftask build
  "Build and install the project locally."
  [d dir PATH #{str} "the set of directories to write to (target)."]
  (let [dir (if (seq dir) dir #{"target"})]
    (comp (aot) (pom) (uber) (jar) (target :dir dir))))

(deftask run
  "Run the project."
  [a args ARG [str] "the arguments for the application."]
  (dev-env!)
  (require '[{{ name }}.core :as app])
  (with-post-wrap fileset
    (apply (resolve 'app/-main) args)))

(deftask gen
  "Generate a leiningen project.clj for with the Cursive IDE."
  []
  (dev-env!)
  (boot.lein/generate))
