(ns {{ name }}.core_test
  (:require [clojure.test :refer :all]

            [clj-http.client :as http]
            [com.stuartsierra.component :as component :refer [using]]

            http-server

            [{{ name }}.core :as core]))

(defn test-config []{{^postgres}}
  (core/load-config "config/config-test.clj"){{/postgres}}{{#postgres}}
  (let [config (core/load-config "config/config-test.clj")]
    (if (System/getenv "TRAVIS")
      (assoc-in config [:db :username] "postgres")
      config)){{/postgres}})

{{^postgres}}
(defn test-system []
  (core/system-component (test-config)))

{{/postgres}}
{{#postgres}}
(defrecord DbCleaner [db]
  component/Lifecycle
  (start [c] c)
  (stop [c]
    ;; TODO: Put any database cleanup code here
    c))

(defn test-system []
  (assoc
    (core/system-component (test-config))
    :db-cleaner (using (->DbCleaner nil) [:db])))

{{/postgres}}
(defmacro with-system [bindings & body]
  `(try
     (let [system# (component/start (test-system))]
       (try
         (let [~(first bindings) system#]
           ~@body)
         (finally
            (component/stop system#))))
     (catch clojure.lang.ExceptionInfo e#
       (if (component/ex-component? e#)
         (do (-> e# ex-data :system component/stop)
             (throw (component/ex-without-components e#)))
         (throw e#)))))

{{^web}}
(deftest starter-integration-test
  (with-system [{:keys [loaded-config]}]
    (is (= "test" (:env loaded-config))
        "The test configuration should be loaded")))
{{/web}}
{{#web}}
(deftest starter-integration-test
  (with-system [{:keys [http-server]}]
    (let [host (http-server/host http-server)
          response (http/get (str host "/hello/bill") {:as :json})]
      (is (= 200 (:status response))
          "Successfully serve hello response")
      (is (= {:hello "bill"} (:body response))
          "The passed in name should be returned"))))
{{/web}}
