/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

enum RedisRunScriptEnum {
    WINDOWS_32("redis-server.exe"),
    WINDOWS_64("redis-server-64.exe"),
    UNIX("redis-server"),
    MACOSX("redis-server.app");

    private final String runScript;

    private RedisRunScriptEnum(String runScript) {
        this.runScript = runScript;
    }

    public static String getRedisRunScript() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osName.contains("win")) {
            if (osArch.contains("64")) {
                return RedisRunScriptEnum.WINDOWS_64.runScript;
            }
            return RedisRunScriptEnum.WINDOWS_32.runScript;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return RedisRunScriptEnum.UNIX.runScript;
        }
        if ("Mac OS X".equalsIgnoreCase(osName)) {
            return RedisRunScriptEnum.MACOSX.runScript;
        }
        throw new RuntimeException("Unsupported os/architecture...: " + osName + " on " + osArch);
    }
}

