# cljs-exif-reader

Extract information from TIFF and JPEG images.

## Usage

Add a dependency to your project:

```clojure
[remworks/cljs-exif-reader "0.5.1"]
```

See [dev/cljs/user.cljs](./dev/cljs/user.cljs) and
[resources/dev.html](./resources/dev.html) for an example of dealing
with a file `<input>` element.

This library also supports CLJ:

```clojure
(require 'remworks.exif-reader)
(-> "resources/test/exif.jpg"
    java.io.File.
    remworks.exif-reader/from-jpeg
    :model)
;; => "Canon PowerShot G3"
```

Also extracts some JPEG information:

```clojure
(-> "resources/test/comment.jpg"
    java.io.File.
    remworks.exif-reader/from-jpeg
    :jpeg)
;; => {:width 100, :height 75, :bits 8, :comments ["Here's a comment!"]}
```

## License

Copyright (c) Remco van 't Veer. All rights reserved.

The use and distribution terms for this software are covered by the
Eclipse Public License 1.0
(http://opensource.org/licenses/eclipse-1.0.php) which can be found in
the file epl-v10.html at the root of this distribution.  By using this
software in any fashion, you are agreeing to be bound by the terms of
this license.  You must not remove this notice, or any other, from
this software.
