# <<name>>

Depending on the chosen integration you will initialize the development
environment in different ways:


## No integration

If you don't use any integration or a integration without automatic building of the ClojureScript code,
make sure that the ClojureScript has been build:

    lein cljsbuild once

When build, open `resources/public/index.html` in a browser and watch for the text
"Launching game" in the browser console.<% if figwheel? %>


## Using Figwheel

From the project directory start Figwheel (which among other things also handle
cljs building):

    lein figwheel

It will take a little time for figwheel to start but afterwards, you get a
ClojureScript REPL.

You can then open the following url in a browser:

    http://localhost:3449/

Not specifying a file in the above URL will serve you `index.html` by default.

Then go back to the ClojureScript REPL started by figwheel, which is now connected to
the `index.html`

If you don't want figwheel to start a ClojureScript REPL automatic, add the
following to `project.clj`

    :figwheel {:repl false}<% endif %><% if weasel? %>


## Using Weasel

Depending on the Weasel integration chosen upon project initialization, you will
need to follow the instructions described above in either "No integration"
(feature: `+weasel`) or "Using Figwheel" (feature: `+figwheel +weasel`).
But before opening the HTML file do the following.

Start a REPL connected to the project. If you can't or don't want to use a REPL
built into your editor (ie. Emacs with Cider jack-in) you can always do it from
`lein`:

    lein repl

Now start a ClojureScript REPL using Weasel:

``` clojure
user> (require 'weasel.repl.websocket)
nil
user> (cemerick.piggieback/cljs-repl
        :repl-env (weasel.repl.websocket/repl-env
                   :ip "0.0.0.0" :port 9001))

<< started Weasel server on ws://0.0.0.0:9001 >>
Type `:cljs/quit` to stop the ClojureScript REPL
nil
```

Now open the HTML as described in instructions above matching your chosen
integration.
<% if figwheel?%>
Normally Starting figwheel will automatically do the steps above
and give you a connected ClojureScript REPL. This have been disabled due to
the choice of using weasel.
<% endif %>
From the ClojureScript REPL switch to your game namespace:

``` clojure
(in-ns '<<name>>.core)
```

Now it's possible to start live interacting with the game ie. watch and change
the `game-state` atom among other things:

``` clojure
@game-state
(swap! game-state assoc :hey "ho")
```<% endif %>


## Profiles

By default two different profiles are specified in the `project.clj` file.
One is for development and the other is for creating a production version.

Remember to clean your compiled ClojureScript code when switching profile, this
can be done with the command `lein clean`.


### Development

The first one is named `dev` and it is the default profile when using `lein` commands.
This profile will initialize any development features you specified while creating the project.

This is also the profile to use if you're using LightTable for development.

The `<<sanitized>>.js` file generated by the `dev` profile, need to have the
namespace `<<sanitized>>.game` required through `goog` to work:

    <script src="game/out/goog/base.js" type="text/javascript"></script>
    <script src="game/<<sanitized>>.js" type="text/javascript"></script>
    <script type="text/javascript">
      goog.require("<<sanitized>>.game");
    </script>


### Production

The second profile is name `prod` and it is designed to be used when creating production version
of your game. It can be used with leiningen to build a production version like this:

    lein with-profile prod cljsbuild once

The `<<sanitized>>.js` file generated by the `prod` profile, only needs to be
required in the `index.html` file to work. To ensure the code isn't run until
the DOM elements is ready the attribute `defer` can be used:

    <script src="game/<<sanitized>>.js" type="text/javascript" defer="defer" />