/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import java.util.Map;
import javax.jms.JMSException;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.codec.StompFrame;
import org.fusesource.stomp.jms.StompJmsPrefetch;
import org.fusesource.stomp.jms.StompServerAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RabbitMQServerAdaptor
extends StompServerAdaptor {
    @Override
    public boolean matchesServerAndVersion(String server) {
        return server.startsWith("RabbitMQ/");
    }

    @Override
    public void addSubscribeHeaders(Map<AsciiBuffer, AsciiBuffer> headerMap, boolean persistent, boolean browser, boolean noLocal, StompJmsPrefetch prefetch) throws JMSException {
        if (browser) {
            throw new JMSException("Server does not support browsing over STOMP");
        }
        if (noLocal) {
            throw new JMSException("Server does not support 'no local' semantics over STOMP");
        }
        if (persistent) {
            headerMap.put(Constants.PERSISTENT, Constants.TRUE);
        }
    }

    @Override
    public StompFrame createUnsubscribeFrame(AsciiBuffer consumerId, boolean persistent) throws JMSException {
        StompFrame frame = new StompFrame();
        Map<AsciiBuffer, AsciiBuffer> headerMap = frame.headerMap();
        frame.action(Constants.UNSUBSCRIBE);
        headerMap.put(Constants.ID, consumerId);
        if (persistent) {
            headerMap.put(Constants.PERSISTENT, Constants.TRUE);
        }
        return frame;
    }
}

