/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import java.util.LinkedList;
import org.fusesource.stomp.jms.MessageQueue;

public class TxMessageQueue
extends MessageQueue {
    private final LinkedList<MessageQueue.QueueEntry> removed = new LinkedList();

    public TxMessageQueue(long maxSize) {
        super(maxSize);
    }

    @Override
    protected void removed(MessageQueue.QueueEntry entry) {
        this.removed.addFirst(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        TxMessageQueue txMessageQueue = this;
        synchronized (txMessageQueue) {
            this.removed.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        TxMessageQueue txMessageQueue = this;
        synchronized (txMessageQueue) {
            for (MessageQueue.QueueEntry entry : this.removed) {
                entry.message.setJMSRedelivered(true);
                this.list.addFirst(entry);
                this.size += (long)entry.size;
            }
            this.removed.clear();
            this.notify();
        }
    }
}

