/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class PropertyUtil {
    public static Map<String, String> parseParameters(URI uri) throws Exception {
        return uri.getQuery() == null ? Collections.EMPTY_MAP : PropertyUtil.parseQuery(PropertyUtil.stripPrefix(uri.getQuery(), "?"));
    }

    public static Map<String, String> parseParameters(String uri) throws Exception {
        return uri == null ? Collections.EMPTY_MAP : PropertyUtil.parseQuery(PropertyUtil.stripUpto(uri, '?'));
    }

    public static Map<String, String> parseQuery(String uri) throws Exception {
        if (uri != null) {
            HashMap<String, String> rc = new HashMap<String, String>();
            if (uri != null) {
                String[] parameters = uri.split("&");
                for (int i = 0; i < parameters.length; ++i) {
                    int p = parameters[i].indexOf("=");
                    if (p >= 0) {
                        String name = URLDecoder.decode(parameters[i].substring(0, p), "UTF-8");
                        String value = URLDecoder.decode(parameters[i].substring(p + 1), "UTF-8");
                        rc.put(name, value);
                        continue;
                    }
                    rc.put(parameters[i], null);
                }
            }
            return rc;
        }
        return Collections.EMPTY_MAP;
    }

    public static String addPropertiesToURIFromBean(String uri, Object bean) throws Exception {
        Map<String, String> props = PropertyUtil.getProperties(bean);
        return PropertyUtil.addPropertiesToURI(uri, props);
    }

    public static String addPropertiesToURI(String uri, Map<String, String> props) throws Exception {
        String result = uri;
        if (uri != null && props != null) {
            StringBuilder base = new StringBuilder(PropertyUtil.stripBefore(uri, '?'));
            Map<String, String> map = PropertyUtil.parseParameters(uri);
            if (!map.isEmpty()) {
                map.putAll(props);
            }
            if (!map.isEmpty()) {
                base.append('?');
                boolean first = true;
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!first) {
                        base.append('&');
                    }
                    first = false;
                    base.append(entry.getKey()).append("=").append(entry.getValue());
                }
                result = base.toString();
            }
        }
        return result;
    }

    public static void setProperties(Object target, Map<String, String> props) {
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (!PropertyUtil.setProperty(target, entry.getKey(), entry.getValue())) continue;
        }
    }

    public static Map<String, String> getProperties(Object object) throws Exception {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        Object[] NULL_ARG = new Object[]{};
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors != null) {
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                Object value;
                PropertyDescriptor pd = propertyDescriptors[i];
                if (pd.getReadMethod() == null || pd.getName().equals("class") || pd.getName().equals("properties") || pd.getName().equals("reference") || (value = pd.getReadMethod().invoke(object, NULL_ARG)) == null) continue;
                if (value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof URI || value instanceof URL) {
                    props.put(pd.getName(), "" + value);
                    continue;
                }
                if (value instanceof SSLContext) continue;
                Map<String, String> inner = PropertyUtil.getProperties(value);
                for (Map.Entry<String, String> entry : inner.entrySet()) {
                    props.put(pd.getName() + "." + entry.getKey(), entry.getValue());
                }
            }
        }
        return props;
    }

    public static Object getProperty(Object object, String name) throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors != null) {
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (pd.getReadMethod() == null || !pd.getName().equals(name)) continue;
                return pd.getReadMethod().invoke(object, new Object[0]);
            }
        }
        return null;
    }

    public static boolean setProperty(Object target, String name, Object value) {
        try {
            int dotPos = name.indexOf(".");
            while (dotPos >= 0) {
                String getterName = name.substring(0, dotPos);
                target = PropertyUtil.getProperty(target, getterName);
                name = name.substring(dotPos + 1);
                dotPos = name.indexOf(".");
            }
            Class<?> clazz = target.getClass();
            Method setter = PropertyUtil.findSetterMethod(clazz, name);
            if (setter == null) {
                return false;
            }
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, PropertyUtil.convert(value, setter.getParameterTypes()[0]));
            }
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static String stripUpto(String value, char c) {
        String result = null;
        int index = value.indexOf(c);
        if (index > 0) {
            result = value.substring(index + 1);
        }
        return result;
    }

    public static String stripBefore(String value, char c) {
        String result = value;
        int index = value.indexOf(c);
        if (index > 0) {
            result = value.substring(0, index);
        }
        return result;
    }

    private static Method findSetterMethod(Class<? extends Object> clazz, String name) {
        name = "set" + ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1) continue;
            return method;
        }
        return null;
    }

    private static Object convert(Object value, Class<?> type) throws Exception {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return null;
    }
}

