(ns leiningen.new.rich-hack-slay
  (:require [clojure.java.browse :refer [browse-url]]
            [leiningen.new.templates :refer [renderer name-to-path ->files project-name sanitize-ns]]
            [leiningen.core.main :as main]))

(def render (renderer "rich-hack-slay"))

(defn rich-hack-slay
  [name]
  (let [data {:raw-name name ; organization/project
              :name (project-name name) ; project
              :namespace (sanitize-ns name) ; organization.project
              :sanitized (name-to-path name)}] ; organization/project
    (main/info "Generating fresh 'lein new' rich-hack-slay in" (project-name name))
    (browse-url "https://www.youtube.com/watch?v=dQw4w9WgXcQ")
    (->files data
             [".gitignore" (render "gitignore" data)]
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["test/{{sanitized}}/core_test.clj" (render "core_test.clj" data)]
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)])))
